\version "2.24.0"
\language "deutsch"
 #(set-global-staff-size 18)

\paper {
  between-system-padding = 0\mm
  markup-system-spacing = #'((basic-distance . 2))
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 8\mm
  bottom-margin = 5\mm
  ragged-last-bottom=##f
  system-count = #9
}

% diacritice: ă â î ş ţ Ţ Ş Ă Î

\header {
  title = "Vine Crăciunu' pe sară"
  %subtitle = "Vino din Liban, mireasă"
  composer =  \markup \center-column { "Nicolae Ursu" \small 
  "(1905 – 1969)" }
  %meter = "Lento"
  tagline=""
}

global = {
  \key g \major
  %\cadenzaOn
  %\autoBeamOff
  \time 4/8
  %\partial 4
  \set Staff.midiInstrument = "clarinet"
}

sopWords = \lyricmode {
  "1.Frun" -- ză ver -- de de să -- ca -- ră,
  Flo -- ri -- le dal -- be,
  vi -- ne Cră -- ciu -- nu' pe sa -- ră.
  "2.D'a" ve -- ni, de n'a ve -- ni -- re,
  Flo -- ri -- le dal -- be,
  Mân -- dru ca -- să mi'oi toc -- mi -- re.
  "3.Pe" __ po -- de -- le, Flori dal -- be,
  Pe -- ste ma -- să.
  "4.La" fe -- rești, pe -- ne dom -- neș -- ti,
  Flo -- ri -- le dal -- be,
  Și la pat, pe -- ne de bra -- du.
  "5.La" o -- bloa -- ce, bu -- su -- ioa -- ce,
  Flori dal -- be,
  Nu __ te coa -- ce.
  "6. Că" te pun fe -- cio -- rii'n cloa -- pă,
  Flo -- ri -- le dal -- be,
  Și fe -- te -- le în co -- si -- ță.
  "7. Și" po -- pa în că -- del -- ni -- ță,
  Flori dal -- be, Că -- del -- ni -- ță,
  Flo -- ri -- le dal -- be. __
}

altoWords = \lyricmode {
  "2.D'a" ve -- ni, de n'a ve -- ni -- re,
  Flo -- ri -- le dal -- be,
  Mân -- dru ca -- să mi'oi toc -- mi -- re.
  "3.Pe" po -- de -- le, scă -- rin -- ge -- le,
  Flo -- ri -- le dal -- be,
  Pe -- ste ma -- să cru -- ce'i tra -- să.
  "4.La" __ fe -- reș -- ti,
  Flo -- ri -- le dal -- be,
  Și la pat, pe -- ne de bra -- du.
  "5.La" __ o -- bloa -- ce,
  Flo -- ri -- le dal -- be,
  Bu -- su -- ioa -- ce, nu te coa -- ce.
  "6. Că" te pun fe -- cio -- rii'n cloa -- pă,
  Flo -- ri -- le dal -- be,
  Și fe -- te -- le în co -- si -- ță.
  "7. Și" po -- pa în că -- del -- ni -- ță,
  Flo -- ri -- le dal -- be, 
  Și po -- pa în că -- del -- ni -- ță,
  Flo -- ri -- le dal -- be. __ 
  Vi -- ne Cră -- ciu -- nu' pe sa -- ră.
}

tenorWords = \lyricmode {
  "3.Pe" po -- de -- le, scă -- rin -- ge -- le,
  Flo -- ri -- le dal -- be,
  Pe -- ste ma -- să cru -- ce'i tra -- să.
  "4.La" fe -- rești, pe -- ne dom -- neș -- ti,
  Flori dal -- be,
  Și __ de bra -- du.
  "5.La" o -- bloa -- ce, bu -- su -- ioa -- ce,
  Flo -- ri -- le dal -- be, Nu __ te coa -- ce.
  "6. Că" te pun fe -- cio -- rii'n cloa -- pă,
  Flo -- ri -- le dal -- be,
  Și fe -- te -- le în co -- si -- ță.
  "7. Și" po -- pa în că -- del -- ni -- ță,
  Flo -- ri -- le dal -- be, 
  Și po -- pa în că -- del -- ni -- ță,
  Flo -- ri -- le dal -- be.  
  Frun -- ză ver -- de de să -- ca -- ră. __
}

bassWords = \lyricmode {
  "4.La" fe -- rești, pe -- ne dom -- neș -- ti,
  Flo -- ri -- le dal -- be,
  Și la pat, pe -- ne de bra -- du.
  "5.La" o -- bloa -- ce, bu -- su -- ioa -- ce,
  Flo -- ri -- le dal -- be,
  Bu -- su -- ioa -- ce, nu te coa -- ce.
  "6. Că" __ te pun în cloa -- pă, Și'n __ co -- si -- ță.
  "7. Și" po -- pa în că -- del -- ni -- ță,
  Flori dal -- be, că -- del -- ni -- ță,
  Flori dal -- be. __
}

sopMusic = \relative c'' {
  g8^\p^\< g c c\!
  \time 3/8
  h4^\accent g8
  \time 4/8
  a4^\accent^\> a^\accent h8^\< d4^\accent e8
  d8.^\accent^\f^\>([ c16]) h4^\accent d8\! d c c
  \time 3/8
  h4^\accent g8
  \time 4/8
  a4^\> a^\fermata \bar"||"
  
  g8^\p^\< g c c\!
  \time 3/8
  h4^\accent g8
  \time 4/8
  a4^\> a g8^\< d'4^\accent e8
  d8.^\f^\>([ c16]) h4 d8\! d c c
  \time 3/8
  h4^\accent g8^\>
  \time 4/8
  a4 a^\fermata\! \bar"||"
  
  g2^\p(
  \time 3/8
  g4) g8
  \time 4/8
  g4^\accent fis^\accent g2 g4^\accent g^\accent
  g2( 
  \time 3/8
  g4) g8^\>
  \time 4/8
  g4^\accent fis\!\fermata  \bar"||"
  
  g8^\f g c c
  \time 3/8
  h4^\accent g8^\>
  \time 4/8 a4^\accent a^\accent h8^\< d4^\accent e8\!
  d8.^\accent([ c16]) h4^\accent d8 d c c
  \time 3/8
  h4^\accent g8^\>
  \time 4/8
  a4 a\!\fermata \bar"||"
  
  g8^\p^\< g a a\!
  \time 3/8
  h4^\accent g8
  \time 4/8
  h4^\accent h4^\accent h2 h4^\accent h4^\accent
  h2( 
  \time 3/8
  h4) h8^\> 
  \time 4/8
  h4 h\! \fermata \bar"||"
  
  g8^\pp^\< g c c\!
  \time 3/8
  h4^\accent g8
  \time 4/8
  a4^\accent a4^\accent h8 d4^\accent e8
  d8.^\accent([ c16]) h4^\accent d8 d c c
  \time 3/8
  h4^\accent g8^\>
  \time 4/8
  a4 a\!\fermata \bar"||"
  
  g8^\f g c c
  \time 3/8
  h4^\accent g8
  \time 4/8
  a4^\accent a^\accent d2^\accent 
  d4\accent d^\accent d2( 
  \time 3/8
  d4) d8
  \time 4/8
  d4^\accent cis^\accent\fermata \bar"||"
  
  d8^\f e4^\accent^\markup"Coda" e8
  fis8.^\accent([ e16]) d4^\accent( d2^\markup"poco a poco dim."
  \time 3/8
  d4.
  \time 4/8
  d2 d
  \time 3/8
  d4.
  \time 4/8
  d2)^\ppp \fermata  
  \bar "|."
}

altMusic = \relative c' {
  r1*4/8 r1*3/8 r1*4/8 r1*4/8 r1*4/8 r1*4/8 r1*3/8 r1*4/8
  \bar"||"
  g'8^\p^\< g g g
  \time 3/8
  g4^\accent\! g8
  \time 4/8
  g4^\>^\accent fis^\accent g8^\< h4^\accent c8 h8.^\f\!([ a16]) g4 h8 h a a
  \time 3/8
  g4^\accent g8^\>
  \time 4/8
  g4 fis\!\fermata \bar"||"
  
  g8^\mf g e e
  \time 3/8
  d4^\accent h8
  \time 4/8
  d4^\accent d^\accent d8 f4^\accent g8 f8.^\accent([ e16]) d4^\accent
  f8 f e e
  \time 3/8
  d4^\accent h8^\>
  \time 4/8
  d4^\accent d4\!\fermata  \bar"||"
  
  g2^\f(
  \time 3/8
  g4) g8^\>
  \time 4/8
  g4^\accent fis^\accent g8^\< a4^\accent g8\!
  a4^\accent h^\accent g8 g fis fis
  \time 3/8
  g4^\accent g8^\>
  \time 4/8
  g4 fis\!\fermata \bar"||"
 
  e2^\p^\<(
  \time 3/8
  e4)\! e8
  \time 4/8
  e4^\accent dis4^\accent e8 g4^\accent a8 
  g8.^\accent([ fis16]) e8.^\accent([ fis16])
  g8 g fis fis
  \time 3/8
  e4^\accent cis8^\>
  \time 4/8
  e4 dis\!\fermata \bar"||"
  
  e8^\pp^\< e a a\!
  \time 3/8
  g4^\accent e8
  \time 4/8
  g4^\accent fis^\accent g8 h4^\accent c8
  h8.^\accent([ a16]) g4^\accent h8 h a a
  \time 3/8
  g4^\accent g8^\>
  \time 4/8
  g4 fis\!\fermata \bar"||"
  
  g8^\f g g g
  \time 3/8
  g4^\accent g8
  \time 4/8
  g4^\accent fis^\accent fis8 a4^\accent h8
  a8.^\accent([ g16]) fis4^\accent a8 a g g
  \time 3/8
  fis4^\accent d8
  \time 4/8
  e4^\accent e^\accent \fermata \bar"||"
  
  fis8^\f g4^\accent g8
  a8.^\accent([ g16]) fis4^\accent(
  fis2
  \time 3/8
  fis4.
  \time 4/8
  fis2)
  <<
   { \voiceOne
    g8^\p g fis g
    \time 3/8
    a4^\accent h8
    \time 4/8
    a4^\ppp a\fermata
   }
   %\autoBeamOff
   \new Voice 
   { \voiceTwo
    %\autoBeamOff 
    e8 e d e
    \time 3/8
    fis4 g8
    \time 4/8
    fis4 fis
   }
   >> 
}

tenorMusic = \relative c' {
  r1*4/8 r1*3/8 r1*4/8 r1*4/8 r1*4/8 r1*4/8 r1*3/8 r1*4/8
  \bar"||"
  r1*4/8 r1*3/8 r1*4/8 r1*4/8 r1*4/8 r1*4/8 r1*3/8 r1*4/8
  \bar"||"
  g8^\mf^\> g c c\!
  \time 3/8
  h4^\accent g8
  \time 4/8
  a4^\>^\accent a^\accent h8^\< d4^\accent e8\! d8.^\accent([ c16]) h4^\accent
  d8 d c c
  \time 3/8
  h4^\accent g8^\>
  \time 4/8
  a4^\accent c4\!\fermata  \bar"||"
  
  h8^\f h e e
  \time 3/8
  d4^\accent c8^\>
  \time 4/8
  e4^\accent d^\accent d2^\<
  d4^\accent\! d^\accent d2(
  \time 3/8
  d4) d8^\>
  \time 4/8
  d4 c\!\fermata \bar"||"
  
  h8^\p^\< h c c\!
  \time 3/8
  h4^\accent h8
  \time 4/8
  h4^\accent h4^\accent e8 e4^\accent e8
  e4^\accent h^\accent e2(
  \time 3/8
  h4) h8^\>
  \time 4/8
  h4 a\!\fermata \bar"||"
  
  g8^\pp^\< g e' e\!
  \time 3/8
  d4^\accent c8
  \time 4/8
  e4^\accent d^\accent d8^\f g4^\accent g8
  g4^\accent d^\accent d8 d e e
  \time 3/8
  d4^\accent h8^\>
  \time 4/8
  d4 c\!\fermata \bar"||"
  
  h8^\f h c c
  \time 3/8
  d4\accent h8
  \time 4/8
  a4^\accent a^\accent a8 c4^\accent d8
  c8.^\accent([ h16]) a4^\accent
  <<
   { \voiceOne
    c8 c h h
   }
   \new Voice 
   { \voiceTwo
    %\autoBeamOff 
    fis8 fis g g
   }
   >> 
  \oneVoice
  \time 3/8
  a4^\accent fis8
  \time 4/8
  g4^\accent a^\accent \bar"||"
   <<
   { \voiceOne
    a8^\f a4^\accent h8 cis4^\accent d^\accent
    c8^\mf c h h
    \time 3/8
    a4^\accent g8
    \time 4/8
    h4^\accent a^\accent( a2
    \time 3/8 a4.
    \time 4/8 a2)^\ppp^\fermata    
   }
   \new Voice 
   { \voiceTwo
    %\autoBeamOff 
    a8 a4 a8 a4 a a8 a g g
    \time 3/8 fis4 e8
    \time 4/8 g4 fis( fis2
    \time 3/8 fis4.
    \time 4/8
    fis2)
   }
   >> 
   

}

bassMusic = \relative c' {
  r1*4/8 r1*3/8 r1*4/8 r1*4/8 r1*4/8 r1*4/8 r1*3/8 r1*4/8
  \bar"||"
  r1*4/8 r1*3/8 r1*4/8 r1*4/8 r1*4/8 r1*4/8 r1*3/8 r1*4/8
  \bar"||"
   r1*4/8 r1*3/8 r1*4/8 r1*4/8 r1*4/8 r1*4/8 r1*3/8 r1*4/8
  \bar"||"
  g8^\f g g g
  \time 3/8
  g4^\accent e8^\>
  \time 4/8
  c4^\accent d^\accent g8^\< fis4^\accent e8\!
  fis4^\accent g8.^\accent([ a16]) h8 h a a
  \time 3/8
  g4^\accent h8^\>
  \time 4/8
  d4 d,\!\fermata \bar"||"
  
  e8^\p^\< e a a\!
  \time 3/8
  g4^\accent e8
  \time 4/8
  fis4^\accent fis^\accent g8^\f h4^\accent c8
  h8.^\accent([ a16]) g8.^\accent([ a16]) h8 h a a
  \time 3/8
  g4^\accent e8^\>
  \time 4/8
  fis4 h,\!\fermata \bar"||"
  
  c2^\pp^\<( 
  \time 3/8
  c4\!) c8
  \time 4/8
  c4^\accent d^\accent 
  
  
  <g g,>2^\f <g g,>2 <g g,>2(
  \time 3/8
  <g g,>4) <g g,>8^\>
  \time 4/8
  <g g,>4 d\!\fermata \bar"||"
  
  g8^\f fis e es
  \time 3/8 d4^\accent e8
  \time 4/8 c4^\accent d^\accent d2^\accent
  d4^\accent d^\accent d2( \time 3/8 d4) d8
  \time 4/8
  d4^\accent a^\accent\fermata \bar"||"
  a2 a4 <d d,>( <d d,>2 \time 3/8 <d d,>4. 
  \time 4/8
  <d d,>2 <d d,> \time 3/8 <d d,>4. \time 4/8 <d d,>2)^\ppp\fermata
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
      \new Voice { \global \sopMusic }
      \addlyrics { \sopWords }
    >>
    \new Staff <<
      \new Voice { \global \altMusic }
      \addlyrics { \altoWords }
    >>
    \new Staff <<
      \clef "G_8"
      \new Voice { \global \tenorMusic }
      \addlyrics { \tenorWords }
    >>
    
    \new Staff <<
      \clef bass
      \new Voice { \global \bassMusic }
      \addlyrics { \bassWords }
    >>
    >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
    \tempo 4 = 60
    \context { \Voice \remove "Dynamic_performer" }
}

\score {
  \myScore
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}
